#import <UIKit/UIKit.h>
#import "VideoStreamBackendDelegate.h"
#import <gst/gst.h>

@interface ViewController : UIViewController <VideoStreamBackendDelegate>
{
    IBOutlet UILabel *message_label;
    IBOutlet UIBarButtonItem *play_button;
    IBOutlet UIBarButtonItem *pause_button;
    IBOutlet UIView *video_container_view;
}

// button-press action outlets
-(IBAction) play:(id)sender;
-(IBAction) stop:(id)sender;

// VideoStreamBackendDelegate

// called when the stream fails to ready
-(void) streamRequestFailed:(id)sender reason:(NSString *)reason;

// called when the stream becomes active or inactive (playing/not playing)
-(void) streamActiveChanged:(id)sender isActive:(BOOL)isActive;

// called when the video stream backend wishes to post a message to the UI
-(void) streamMessage:(id)sender message:(NSString *)message;

@end
